var s_tXMLIsland = null;

var g_aSawMonthDays = new Array(31,28,31,30,31,30,31,31,30,31,30,31);

var g_sDateParseTokens = '^([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+) \\s*';

function SAWDateTime()
{
   this.year = null;
   this.month = null;
   this.day = null;
   this.hour = null;
   this.minute = null;
   this.second = null;
   this.nanoseconds = null;
}

SAWDateTime.padNumber = function(n, nPad)
{
   var s = '' + n;

   return s.length >= nPad ? s : ('000000000'.substr(0,nPad-s.length) + s);
}


SAWDateTime.prototype.isYearValid = function()
{
   return this.year != null && this.year != 0;
}

SAWDateTime.prototype.isYearMonthValid = function()
{
   return this.isYearValid() && (this.month != null && this.month >= 1 && this.month <= 12);
}

SAWDateTime.prototype.isMonthDayValid = function()
{
   if(this.month == null || this.day == null)
      return false;

   return this.month >= 1 && this.month <= 12 && this.isDayValid(this.month, null);
}

SAWDateTime.prototype.isDayValid = function(month, year)
{
   if(this.day == null || this.day < 1)
      return false;

   if(month == 2)
   {
      var bLeap = year == null || ((year % 4) == 0 && ((year % 100) != 0 || (year % 400) == 0));

      return bLeap ? this.day <= 29 : this.day <= 28;
   }
   else
      return this.day <= g_aSawMonthDays[month-1];
}

SAWDateTime.prototype.isDateValid = function()
{
   if(!this.isYearMonthValid())
      return false;

   return (this.day != null) && (this.month >= 1 && this.month <= 12) &&
      this.isDayValid(this.month, this.year);
}

SAWDateTime.prototype.isTimeValid = function()
{
   if(this.hour == null || this.minute == null || this.second == null)
      return false;

   return this.hour >= 0 && this.hour < 24
      && this.minute >= 0 && this.minute < 60
      && this.second >= 0 && this.second < 60
      && (this.nanoseconds == null
         || (this.nanoseconds >= 0 && this.nanoseconds < 1000000000));
}

SAWDateTime.convertFromXml = function(tExpr)
{
   var sValue = XUIGetElementText(tExpr);

   switch(tExpr.getAttribute('xsi:type'))
   {
      case 'xsd:date':
         return DateTimeParser.parseXmlDate(sValue);
      case 'xsd:time':
         return DateTimeParser.parseXmlTime(sValue);
      case 'xsd:dateTime':
         return DateTimeParser.parseXmlDateTime(sValue);
   }

   return null;
}

function DateTimeParser()
{
}

DateTimeParser.notEmptyValue = function(s)
{
   return s == null || s.length == 0 ? null : parseInt(s,10);
}

SAWDateTime.prototype.asDatePortion = function()
{
   var t = new SAWDateTime();

   t.year = this.year;
   t.month = this.month;
   t.day = this.day;
   return t;
}

SAWDateTime.prototype.asTimePortion = function()
{
   var t = new SAWDateTime();

   t.hour = this.hour;
   t.minute = this.minute;
   t.second = this.second;
   t.nanoseconds = this.nanoseconds;
}

SAWDateTime.prototype.dateString = function()
{
   return SAWDateTime.padNumber(this.year,4) + '-' + SAWDateTime.padNumber(this.month,2) + '-' +
      SAWDateTime.padNumber(this.day,2);
}

SAWDateTime.prototype.timeString = function()
{
   return SAWDateTime.padNumber((this.hour!=null?this.hour:0),2) + ':' + SAWDateTime.padNumber((this.minute!=null?this.minute:0),2) + ':' +
      SAWDateTime.padNumber((this.second!=null?this.second:0),2);
}

SAWDateTime.prototype.asOdbcTimeLiteral = function()
{
   return "time '" + this.timeString() + "'";
}

SAWDateTime.prototype.asOdbcDateLiteral = function()
{
   return "date '" + this.dateString() + "'";
}

SAWDateTime.prototype.asOdbcDateTimeLiteral = function()
{
   return "timestamp '" + this.dateString() + ' ' + this.timeString() + "'";
}

SAWDateTime.prototype.asOdbcLiteral = function()
{
   if(this.isDateValid())
   {
      if(this.isTimeValid())
         return this.asOdbcDateTimeLiteral();
      else return this.asOdbcDateLiteral();
   }
   else return this.asOdbcTimeLiteral();
}

SAWDateTime.prototype.asXsiTime = function()
{
   return this.timeString();
}

SAWDateTime.prototype.asXsiDate = function()
{
   return this.dateString();
}

SAWDateTime.prototype.asXsiDateTime = function()
{
   return this.dateString() + 'T' + this.timeString();
}

SAWDateTime.prototype.asXml = function()
{
   var tXml = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

   var sText = '';

   if(this.year != null)
   {
      sText = SAWDateTime.padNumber(this.year,4);

      if(this.month == null)
      {
         XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'gYear');
      }
      else
      {
         sText += '-' + SAWDateTime.padNumber(this.month,2);

         if(this.day == null)
         {
            XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'gYearMonth');
         } else
         {
            sText += '-' + SAWDateTime.padNumber(this.day,2);

            if(this.hour == null)
            {
               XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'date');
            } else
            {
               XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'dateTime');

               sText += 'T' + SAWDateTime.padNumber(this.hour,2) + ':' + SAWDateTime.padNumber(this.minute,2) + ':';

               if(this.nanoseconds != null)
               {
                  if(this.second < 10)
                     sText += '0';

                  sText += (this.second + (this.nanoseconds / 1000000000));
               }
               else sText += SAWDateTime.padNumber(this.second,2);
            }
         }
      }
   }
   else    // year is null
   {
      if(this.month != null)
      {
         if(this.day == null)
         {
            XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'gMonth');

            sText = '--' + SAWDateTime.padNumber(this.month,2) + '--';
         } else
         {
            XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'gMonthDay');

            sText = '--' + SAWDateTime.padNumber(this.month,2) + '-' + SAWDateTime.padNumber(this.day,2);
         }
      }
      else if(this.day != null)
      {
         XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'gDay');

         sText = '---' + SAWDateTime.padNumber(tDateTime.day,2);
      } else // we must have a time
      {
          XUISetXsiType(tXml, saw.xml.kXsdNamespace, 'time');
            sText = SAWDateTime.padNumber(this.hour,2) + ':' + SAWDateTime.padNumber(this.minute,2) + ':';

         if(this.nanoseconds != null)
         {
            if(this.second < 10)
               sText += '0';

            sText += (this.second + (this.nanoseconds / 1000000000));
         }
         else sText += SAWDateTime.padNumber(this.second,2);

      }
   }

   tXml.appendChild(saw.getXmlIsland().createTextNode(sText));

   return tXml;
}

/*
SAWDateTime.prototype.adjustUTCToLocalTimezone = function()
{
   var lDateVal = Date.UTC (this.year, this.month, this.day, this.hour,
                            this.minute, this.second, this.nanoseconds / 1000000);
   var tDateObject = new Date (lDateVal);

   // get the adjusted values and store in this object
   this.year = tDateObject.getFullYear ();
   this.month = tDateObject.getMonth ();
   this.day = tDateObject.getDate ();
   this.hour = tDateObject.getHours ();
   this.minute = tDateObject.getMinutes ();
   this.second = tDateObject.getSeconds ();
   this.nanoseconds = 1000000 * tDateObject.getMilliseconds ();
}  */

// add nMinutes minutes. This doesn't work for time before year 1970
SAWDateTime.prototype.adjustTimeZoneOffset = function(nMinutes)
{
   if (nMinutes == 0)
      return;
      
   if (this.year < 1970)
   {
      //alert("Can't handle date before year 1970!");
      return;
   }
      
   var lDateVal = Date.UTC (this.year, this.month - 1, this.day, this.hour,
                            this.minute, this.second, this.nanoseconds / 1000000);
   var tDateTime = new Date(lDateVal + nMinutes * 60000);
   
   // get the adjusted values and store in this object
   this.year = tDateTime.getUTCFullYear ();
   this.month = tDateTime.getUTCMonth () + 1;
   this.day = tDateTime.getUTCDate ();
   this.hour = tDateTime.getUTCHours ();
   this.minute = tDateTime.getUTCMinutes ();
   this.second = tDateTime.getUTCSeconds ();
}

////////////////////////////////////////////////////////////////////////////////
// DateTimeParser

DateTimeParser.parseAndFormInputString = function(sDateTime)
{   
   var tDTP = new DateTimeParser();
   
   var t = tDTP.parseDateTime(sDateTime);
   if (t == null) // try date and turn into datetime
   {
      t = tDTP.parseDate(sDateTime);
      if (t != null)
         t = tDTP.parseDateTime(sDateTime + " 00:00:00");
   }
   if (t)
   {
      return tDTP.formInputString(t);
   }
   else
      return sDateTime;
}

DateTimeParser.parseAndFormXsiDateTimeString = function(sDateTime, sDataType)
{   
   var tDTP = new DateTimeParser();
   
   var t = tDTP.parseDateTime(sDateTime);
   if (t == null) // try date and turn into datetime
   {
      t = tDTP.parseDate(sDateTime);
      if (t != null)
         t = tDTP.parseDateTime(sDateTime + " 00:00:00");
   }
   if (t)
   {
      if (sDataType == "date")
         return t.asXsiDate();
      else if (sDataType == "time")
         return t.asXsiTime();
      else //assume (sDataType == "dateTime")
         return t.asXsiDateTime();
   }
   else
      return sDateTime;
}

DateTimeParser.prototype.formInputString = function(tDateTime)
{
   var s = '';

   if(tDateTime.isDateValid())
   {
      if(g_LocaleInfo.sDateOrder == 'ymd')
      {
         s += SAWDateTime.padNumber(tDateTime.year,g_LocaleInfo.nYearPadding);
         s += g_LocaleInfo.sDateSeparator;
         s += SAWDateTime.padNumber(tDateTime.month,g_LocaleInfo.nMonthPadding);
         s += g_LocaleInfo.sDateSeparator;
         s += SAWDateTime.padNumber(tDateTime.day,g_LocaleInfo.nDayPadding);
      } else if(g_LocaleInfo.sDateOrder == 'mdy')
      {
         s += SAWDateTime.padNumber(tDateTime.month,g_LocaleInfo.nMonthPadding);
         s += g_LocaleInfo.sDateSeparator;
         s += SAWDateTime.padNumber(tDateTime.day,g_LocaleInfo.nDayPadding);
         s += g_LocaleInfo.sDateSeparator;
         s += SAWDateTime.padNumber(tDateTime.year,g_LocaleInfo.nYearPadding);
      } else
      {
         s += SAWDateTime.padNumber(tDateTime.day,g_LocaleInfo.nDayPadding);
         s += g_LocaleInfo.sDateSeparator;
         s += SAWDateTime.padNumber(tDateTime.month,g_LocaleInfo.nMonthPadding);
         s += g_LocaleInfo.sDateSeparator;
         s += SAWDateTime.padNumber(tDateTime.year,g_LocaleInfo.nYearPadding);
      }
   }

   if(tDateTime.isTimeValid())
   {
      if(s.length > 0)
         s += ' ';

      if(g_LocaleInfo.b24)
      {
         s += SAWDateTime.padNumber(tDateTime.hour,g_LocaleInfo.nHourPadding);
      } else
      {
         s += SAWDateTime.padNumber((tDateTime.hour%12) == 0 ? 12 : (tDateTime.hour%12),g_LocaleInfo.nHourPadding);
      }

      s += g_LocaleInfo.sTimeSeparator;

      s += SAWDateTime.padNumber(tDateTime.minute,2);

      s += g_LocaleInfo.sTimeSeparator;

      s += SAWDateTime.padNumber(tDateTime.second,2);

		if(tDateTime.nanoseconds > 0)
		{
			s += g_LocaleInfo.sDecimalPoint;
			
			var nPad = 9;
			
			var n = tDateTime.nanoseconds;
			
			while(n % 10 == 0)
			{
			   n = n / 10;
			   --nPad;
			}
			
			s += SAWDateTime.padNumber(n,nPad);
		}
		
      if(!g_LocaleInfo.b24)
      {
         s += ' ' + (tDateTime.hour < 12 ? g_LocaleInfo.sAM : g_LocaleInfo.sPM);
      }
   }

   return s;
}

DateTimeParser.matchExpression = function(sRegularExpr, s, year, month, day, hour, minute, second, nanoseconds, AMPM)
{
   var aMatches = s.match(RegExp(sRegularExpr));

   if(aMatches != null)
   {

      var t = new SAWDateTime;

      if(year != null)
      {
         t.year = DateTimeParser.notEmptyValue(aMatches[year]);

         if(t.year != null && aMatches[year].length == 2)
         {
            t.year += (t.year < 63) ? 2000 : 1900;
         }

         if(t.year == 0)
            return null;
      }

      if(month != null)
         t.month = DateTimeParser.notEmptyValue(aMatches[month]);

      if(day != null)
         t.day = DateTimeParser.notEmptyValue(aMatches[day]);

      if(hour != null)
         t.hour = DateTimeParser.notEmptyValue(aMatches[hour]);

      if(minute != null)
         t.minute = DateTimeParser.notEmptyValue(aMatches[minute]);

      if(second != null)
         t.second = DateTimeParser.notEmptyValue(aMatches[second]);

      if(nanoseconds != null)
         t.nanoseconds = DateTimeParser.notEmptyValue(aMatches[nanoseconds]);

      if(t.nanoseconds != null)
      {
         t.nanoseconds = Math.round((t.nanoseconds / Math.pow(10,aMatches[nanoseconds].length)) * 1000000000);

         if(t.nanoseconds >= 1000000000)
            t.nanoseconds = 999999999;
      }

      if(t.hour != null && AMPM != null && typeof(AMPM) != 'undefined')
      {
         if((aMatches[AMPM] == 'PM' || aMatches[AMPM] == aMatches[5]) && t.hour != 12)
               t.hour += 12;
         else if((aMatches[AMPM] == 'AM' || aMatches[AMPM] == aMatches[4]) && t.hour == 12)
               t.hour = 0;
      }
   } else return null;


   return t;
}

DateTimeParser.prototype.parse = function(sInput,nType)
{

   var s = g_LocaleInfo.sDateSeparator + ' ' + g_LocaleInfo.sTimeSeparator + ' ' + g_LocaleInfo.sDecimalPoint + ' ' + g_LocaleInfo.sAM + ' ' + g_LocaleInfo.sPM + ' ' + sInput;

   var sYear = '(-?[0-9][0-9]+)';
   var sMonth = '(?:0*((?:[1-9])|(?:1[0-2])))';
   var sDay = '(0*(?:[1-9])|(?:[12][0-9])|(?:3[0-1]))';
   var s24Time = '([0-9]+)\\2([0-9]+)\\2([0-9]+)(?:\\3([0-9]*))?';
   var s12Time = '([0-9]+)\\2([0-9]+)\\2([0-9]+)(?:\\3([0-9]*))?(?:\\s*(AM|PM|\\4|\\5))?';
   var s12TimeAMPMbefore = '(?:(AM|PM|\\4|\\5)\\s*)?([0-9]+)\\2([0-9]+)\\2([0-9]+)(?:\\3([0-9]*))?';

   var sDateTimeRE;


   if((nType & 1) != 0)
   {
      var t = null;
      var sRE;

      if(g_LocaleInfo.sDateOrder == 'ymd')   // datetime
      {
         sRE = g_sDateParseTokens + sYear + '\\1' + sMonth + '\\1' + sDay + '\\s+' + (g_LocaleInfo.b24 ? s24Time : s12Time) + '\\s*$';

         t = DateTimeParser.matchExpression(sRE, s, 6,7,8,9,10,11,12,13);
         if (t == null && !g_LocaleInfo.b24)
         {
            sRE = g_sDateParseTokens + sYear + '\\1' + sMonth + '\\1' + sDay + '\\s+' + s12TimeAMPMbefore + '\\s*$';
            t = DateTimeParser.matchExpression(sRE, s, 6,7,8,10,11,12,13,9);
         }		
      } else if(g_LocaleInfo.sDateOrder == 'mdy')
      {
         sRE = g_sDateParseTokens + sMonth + '\\1' + sDay + '\\1' + sYear + '\\s+' + (g_LocaleInfo.b24 ? s24Time : s12Time) + '\\s*$';

         t = DateTimeParser.matchExpression(sRE, s, 8,6,7,9,10,11,12,13);
         if (t == null && !g_LocaleInfo.b24)
         {
            sRE = g_sDateParseTokens + sMonth + '\\1' + sDay + '\\1' + sYear + '\\s+' + s12TimeAMPMbefore + '\\s*$';
            t = DateTimeParser.matchExpression(sRE, s, 8,6,7,10,11,12,13,9);
         }
      } else
      {
        sRE = g_sDateParseTokens + sDay + '\\1' + sMonth + '\\1' + sYear + '\\s+' + (g_LocaleInfo.b24 ? s24Time : s12Time) + '\\s*$';
        t = DateTimeParser.matchExpression(sRE, s, 8, 7, 6, 9, 10,11,12,13);
        if (t == null && !g_LocaleInfo.b24)
        {
           sRE = g_sDateParseTokens + sDay + '\\1' + sMonth + '\\1' + sYear + '\\s+' + s12TimeAMPMbefore + '\\s*$';
           t = DateTimeParser.matchExpression(sRE, s, 8,7,6,10,11,12,13,9);
        }
      }

      if(t == null)
      {
         sRE = g_sDateParseTokens + sYear + '\\1' + sMonth + '\\1' + sDay + '\\s+' + s24Time + '\\s*$';

         t = DateTimeParser.matchExpression(sRE, '- : . AM PM '+sInput, 6,7,8,9,10,11,12, null);
      }

      if(t != null && t.isDateValid() && t.isTimeValid())
      {
         return t;
      }
   }

   if((nType & 2) != 0)   // date
   {
      var t = null;
      var sRE = g_sDateParseTokens;

      if(g_LocaleInfo.sDateOrder == 'ymd')
      {
         sRE += sYear + '\\1' + sMonth + '\\1' + sDay + '\\s*$';

         t = DateTimeParser.matchExpression(sRE, s, 6,7,8, null, null, null, null, null);

      } else if(g_LocaleInfo.sDateOrder == 'mdy')
      {
         sRE += sMonth + '\\1' + sDay + '\\1' + sYear + '\\s*$';
         t = DateTimeParser.matchExpression(sRE, s, 8,6,7, null, null, null, null, null);
      } else
      {
         sRE += sDay + '\\1' + sMonth + '\\1' + sYear + '\\s*$';
         t = DateTimeParser.matchExpression(sRE, s, 8, 7, 6, null, null, null, null, null);
      }

      if(t == null)
      {
         sRE = g_sDateParseTokens;
         sRE += sYear + '\\1' + sMonth + '\\1' + sDay + '\\s*$';
         t = DateTimeParser.matchExpression(sRE, '- : . AM PM '+sInput, 6,7,8, null, null, null, null, null);
      }

      if(t != null && t.isDateValid())
         return t;
    }

    if((nType & 4) != 0) // time
    {
       var t = null;
       var sRE = g_sDateParseTokens +  (g_LocaleInfo.b24Time ? s24Time : s12Time) + '\\s*$';


        t = DateTimeParser.matchExpression(sRE, s, null, null, null, 6, 7, 8, 9, null);

        if (t == null && !g_LocaleInfo.b24)
        {
           sRE = g_sDateParseTokens + s12TimeAMPMbefore + '\\s*$';
           t = DateTimeParser.matchExpression(sRE, s, null,null,null,7,8,9,10,null);
        }
		
        if(t == null)
        {
           t = DateTimeParser.matchExpression(g_sDateParseTokens + s24Time + '\\s*$',
            '- : . AM PM '+sInput, null, null, null, 6, 7, 8, 9, null);

        }

        if(t != null && t.isTimeValid())
            return t;
    }

    if(nType & 16) // month - day
    {
         var t = null;
        var sRE = g_sDateParseTokens;

        if(g_LocaleInfo.sDateOrder == 'ymd' || g_LocaleInfo.sDateOrder == 'mdy')
        {
            sRE += sMonth + '\\1' + sDay + '\\s*$';
            t = DateTimeParser.matchExpression(sRE, s, null, 6,7, null, null, null, null, null);
        } else
        {
            sRE += sDay + '\\1' + sMonth + '\\s*$';
            t = DateTimeParser.matchExpression(sRE, s, null, 7,6, null, null, null, null, null);
        }

        if(t != null && t.isMonthDayValid())
            return t;
    }

    if(nType & 8) // year - month
    {
       var t = null;
       var sRE = g_sDateParseTokens;

        if(g_LocaleInfo.sDateOrder == 'ymd')
        {
            sRE += sYear + '\\1' + sMonth + '\\s*$';
            t = DateTimeParser.matchExpression(sRE, s, 6,7, null, null, null, null, null, null);
        } else
        {
            sRE += sMonth + '\\1' + sYear + '\\s*$';
            t = DateTimeParser.matchExpression(sRE, s, 7,6, null, null, null, null, null, null);
        }

        if(t != null && t.isYearMonthValid())
         return t;
    }


   if(nType & 32) // year
   {
       var t = null;
       var sRE = g_sDateParseTokens;

        sRE += sYear + '\\s*$';
        t = DateTimeParser.matchExpression(sRE, s, 6, null, null, null, null, null, null, null);

        if(t != null && t.isYearValid())
         return t;
    }


   return null;
 }



DateTimeParser.prototype.parseDateTime = function(sInput)
{
   return this.parse(sInput,1);
}

DateTimeParser.prototype.parseDate = function(sInput)
{
   return this.parse(sInput,2);
}

DateTimeParser.prototype.parseTime = function(sInput)
{
   return this.parse(sInput,4);
}

DateTimeParser.prototype.parseYear = function(sInput)
{
   return this.parse(sInput,32);
}

DateTimeParser.prototype.parseYearMonth = function(sInput)
{
   return this.parse(sInput,8);
}

DateTimeParser.prototype.parseMonthDay = function(sInput)
{
   return this.parse(sInput,16);
}

DateTimeParser.parseXmlDate = function(sInput)
{
   var sRE = '^\s*(-?[0-9][0-9]+)-(?:0*((?:[1-9])|(?:1[0-2])))-(0*(?:[1-9])|(?:[12][0-9])|(?:3[0-1]))\s*$';

   var t = DateTimeParser.matchExpression(sRE,sInput,1,2,3, null, null, null, null, null);

   if(t != null && t.isDateValid())
      return t;

   return null;
}

DateTimeParser.parseXmlTime = function(sInput)
{
   var sRE = '^\s*([0-9]+):([0-9]+):([0-9]+)(?:\.([0-9]*))?$';

   var t = DateTimeParser.matchExpression(sRE,sInput,null,null,null,1,2,3,4, null);

   if(t != null && t.isTimeValid())
      return t;

   return null;
}

DateTimeParser.parseXmlDateTime = function(sInput)
{
   var sRE = '^\s*([0-9]+)-([0-9]+)-([0-9]+)\s*T\s*([0-9]+):([0-9]+):([0-9]+)(?:\.([0-9]*))?$';

   var t = DateTimeParser.matchExpression(sRE,sInput,1,2,3,4,5,6,7, null);

   if(t != null && t.isDateValid() && t.isTimeValid())
      return t;

   return null;
}

DateTimeParser.buildDateTimeClause = function(sOp, sFormula, sPrimaryType, tA)
{
     var sA = null;

     if(tA.isDateValid())
	  {
	      if(tA.isTimeValid())
	      {
   	      sA = sFormula + ' ' + sOp + '= ' + tA.asOdbcLiteral();
   	   } else
   	   {
   	      if(sPrimaryType != 'date')
      	      sA = 'CAST(' + sFormula + ' AS DATE) ' + sOp + '= ' + tA.asOdbcLiteral();
      	   else sA = sFormula + sOp + '= ' + tA.asOdbcLiteral();
   	   }
   	} else if(tA.isTimeValid())
   	{
   	   if(sPrimaryType != 'time')
   	      sA = 'CAST(' +sFormula + ' AS TIME) ' + sOp + '= ' + tA.asOdbcLiteral();
   	   else sA = sFormula + sOp + '= ' + tA.asOdbcLiteral();
	   } else if(tA.isYearValid())
	   {
	      if(tA.isYearMonthValid())
	      {
	         sA = '((YEAR(' + sFormula + ') = ' + tA.year;
	         sA += ' AND MONTH(' + sFormula  + ') ' + sOp + '= ' + tA.month;
	         sA += ') OR YEAR(' + sFormula + ') ' + sOp + ' ' + tA.year + ')';

	      } else
	      {
	         sA = 'YEAR(' + sFormula + ') ' + sOp + '= ' + tA.year;
	      }
	   } else if(tA.isMonthDayValid())
	   {
	         sA = '((MONTH(' + sFormula + ') = ' + tA.month;
	         sA += ' AND DAY(' + sFormula + ') ' + sOp + '= ' + tA.day;
	         sA += ') OR MONTH(' + sFormula + ') ' + sOp + ' ' + tA.month + ')';
	   }

   return sA;

}



////////////////////////////////////////////////////////////////////////////////
// saw.tz namespace
// functions related to timezone

if(typeof(saw.tz) == 'undefined')
{
   saw.tz = function() {};
}

saw.tz.kUseDefaultOffset = -11111;
saw.tz.kUnknownOffset = -22222;

saw.tz.kUseDefaultID = 'default';
saw.tz.kUnknownID = 'Unknown';

//-----------------------------------------------------------------------------
// TimeZoneInfoNode containing the timezone info (default timezones and timezone list)

// get the timezone info node
saw.tz.getTimeZoneInfoNode = function()
{
   var tNQW = XUIGetRootXML();
   return tNQW? tNQW.selectSingleNode('saw:timeZoneInfo') : null;
}


// set the timezone info xml, used only in serverResponse after get the timezone list via server call
saw.tz.setTimeZoneInfoNode = function(tTimeZoneInfo)
{   
   var tNQW = XUIGetRootXML();
   if (tNQW)
   {
      var tOld = tNQW.selectSingleNode('saw:timeZoneInfo');
      if (tOld == null)
         tNQW.appendChild(tTimeZoneInfo);
      else
         tOld.parentNode.replaceChild(tTimeZoneInfo, tOld);
   }
}

//-----------------------------------------------------------------------------

// display timezone offset for general timestamps
saw.tz.getGeneralDisplayTZOffset = function()
{
   var tNode = saw.tz.getTimeZoneInfoNode();
   if (tNode != null)
   {
      var sOffset = tNode.getAttribute('generalDisplayTZOffset');
      if (sOffset)
      {
         var nOffset = parseInt(sOffset);
         if (nOffset)
            return nOffset;
      }
   }
  
   return 0;   
}

// default display timezone for DATA
saw.tz.getDefaultDisplayTimeZone = function()
{
   var tNode = saw.tz.getTimeZoneInfoNode();
   if (tNode != null)
   {
      return tNode.getAttribute('displayDefaultTZ');
   }
   
   return null;
}

//-----------------------------------------------------------------------------

saw.tz.getTimeZoneNameByID = function(sID)
{
   var tTZInfos = saw.tz.getTimeZoneInfoNode();
   if (tTZInfos != null)
   {
      var tTZ = tTZInfos.selectSingleNode("saw:timeZone[@id='" + sID + "']");
      if (tTZ != null)
         return tTZ.getAttribute('name');
   }
   
   return sID;
}

saw.tz.getOffsetById = function(sID)
{
   var tTZInfos = saw.tz.getTimeZoneInfoNode();
   if (tTZInfos != null)
   {
      var tTZ = tTZInfos.selectSingleNode("saw:timeZone[@id='" + sID + "']");
      if (tTZ != null)
         return tTZ.getAttribute('offset');
   }
   
   return saw.tz.kUnknownOffset;
}

//-----------------------------------------------------------------------------

saw.tz.isOffsetUseDefault = function(offset)
{
   return offset == saw.tz.kUseDefaultOffset;
}

saw.tz.isOffsetUnknown = function(offset)
{
   return offset == saw.tz.kUnknownOffset;
}

saw.tz.isOffsetValid = function(offset)
{
   return offset >= -780 && offset <= 840 && offset % 15 ==0;
}

saw.tz.offsetToString = function(nOffset)
{
   if (!saw.tz.isOffsetValid(nOffset))
      return kmsgDataTimeZoneUnknown;
   if (nOffset >= 0)
   {
      var nHours = (nOffset - nOffset%60) /60;
      return 'GMT+' + (nHours > 9? '':'0') + nHours + ':' + (nOffset%60 > 9? '':'0') + nOffset%60;
   }
   else   
   {
      nOffset = -nOffset;
      var nHours = (nOffset - nOffset%60) /60;
      return 'GMT-' + (nHours > 9? '':'0') + nHours + ':' + (nOffset%60 > 9? '':'0') + nOffset%60;
   }
}

// parse sDateTime string, add nTimeZoneOffset minutes and return as string
// if the string can't be parsed, the original string is retruned
saw.tz.parseAndAdjustTimeZoneOffset = function (sDateTime, nTimeZoneOffset)
{
   if (sDateTime)
   {
      if (typeof(nTimeZoneOffset)=='number')
      {
         var tDTP = new DateTimeParser();
         var tDateTime = tDTP.parse(sDateTime, 1 | 2 | 4 | 8 | 16 | 32);
         if (tDateTime)
         {
            tDateTime.adjustTimeZoneOffset(nTimeZoneOffset);
            var sValue = tDateTime.dateString() + ' ' + tDateTime.timeString();
            return sValue;
         }
      }
   }   

   return sDateTime;
}

////////////////////////////////////////////////////////////////////////////////
// Following funtions get a column's timezone infos according to the column formula, 
// ColumnSpace node and criteria node. They can only be used for reports.
// DON'T use the following function in Global Filter Prompts, their column space is 
// different, and has it is own implementation.

// get the data timezone offset of a column
// tColumnInfo is a xml node in the column space
saw.tz.getDataTZOffset = function(tColumnInfo)
{
   var nDataOffset = saw.tz.kUnknownOffset;
   
   var sDataOffset = XUIColumnSpace.getInfoSQLAttr(tColumnInfo, "timeZone");
   if (sDataOffset == null || saw.tz.isOffsetUseDefault(sDataOffset))
   {
      var tTZNode = saw.tz.getTimeZoneInfoNode();
      if (tTZNode != null)
      {
         sDataOffset = tTZNode.getAttribute('dataDefaultTZOffset');
      }
   }
   
   if (sDataOffset != null)
      nDataOffset = parseInt(sDataOffset);
   
   return nDataOffset;
}

// get the display timezone ID of a column
saw.tz.getDisplayTimeZone = function(tColumnInfo, tCriteriaXml)
{  
   var tDataFormat = saw.tz.getDataFormatNode(XUIGetAttributeString(tColumnInfo, "formula"), tCriteriaXml);

   var sDisplayTZ = '';
   if (tDataFormat != null)
   {
      sDisplayTZ = tDataFormat.getAttribute('displayTimeZone');
   }
   
   if (sDisplayTZ && sDisplayTZ != saw.tz.kUseDefaultID)
      return sDisplayTZ;

   return XUIGetAttributeString(tColumnInfo, 'displayDefaultTZ', saw.tz.kUnknownID);
}

// get the display timezone offset of a column
// sDisplayTZ is timezone ID get via saw.tz.getDisplayTimeZone
saw.tz.getDisplayTZOffset = function(tColumnInfo, sDisplayTZ)
{
   var tTZNode = saw.tz.getTimeZoneInfoNode();

   var sDisplayOffset = null;

   if (sDisplayTZ)
   {
      if (sDisplayTZ == tColumnInfo.getAttribute('displayDefaultTZ'))
      {
         sDisplayOffset = tColumnInfo.getAttribute('displayDefaultTZOffset')
      }
      else if (tTZNode != null)
      {  //timezone specified by the column data format, find it from the TZ list
         // find the offset from the time zone xml
         var tTZ = tTZNode.selectSingleNode("//saw:timeZone[@id='" + sDisplayTZ + "']");
         if (tTZ != null)
            sDisplayOffset = tTZ.getAttribute('offset');
      }

   }   
   else if (tTZNode != null)  
   {
      //use the system default
      sDisplayOffset = tTZNode.getAttribute('displayDefaultTZOffset');
   }
   
   if (sDisplayOffset && saw.tz.isOffsetValid(sDisplayOffset))
   {
      var nDisplayOffset = parseInt(sDisplayOffset);
      if (!isNaN(nDisplayOffset))
         return nDisplayOffset;
   }

   return saw.tz.kUnknownOffset;      
}

//offset needs to be added when converting value form display timezone to data timezone
saw.tz.getDisplayToDataTZOffset = function(tColumnInfo, sDisplayTZ)
{
   if (sDisplayTZ == saw.tz.kUnknownID)
      return 0;
      
   // get data timezone offset   
   var nDataOffset = saw.tz.getDataTZOffset(tColumnInfo);
      
   if (!saw.tz.isOffsetValid(nDataOffset))
      return 0;
      
   // display timezone offset
   var nDisplayOffset = saw.tz.getDisplayTZOffset(tColumnInfo, sDisplayTZ);
   
   if (saw.tz.isOffsetValid(nDisplayOffset))
      return nDataOffset - nDisplayOffset;

   return 0;
}

// get the display format node in the primary criteria, tCriteriaXml may be a sub-criteria
saw.tz.getDataFormatNode = function(sFormula, tCriteriaXml)
{   
   // handle derived criteria
   if (tCriteriaXml.parentNode != null && tCriteriaXml.parentNode.nodeName == 'saw:criteria')
   {
      var tColumn = tCriteriaXml.selectSingleNode("saw:columns/saw:column[@formula='" + sFormula + "']");
      if (tColumn != null)
      {
         var nIndex = saw.getChildElementLogicalIndex(tCriteriaXml.selectSingleNode('saw:columns'), tColumn);
         var tPrimaryCriteria = tCriteriaXml.selectSingleNode("//saw:criteria[@xsi:type='saw:derived']");
         if (tPrimaryCriteria != null)
         {
            var tColumns = tPrimaryCriteria.selectSingleNode('saw:columns');
            if (tColumns != null)
            {
               tColumn = saw.getChildElementByIndex(tColumns, nIndex);
               return tColumn.selectSingleNode("saw:displayFormat/saw:dataFormat");
            }
         }
      }
   }
   else
      return tCriteriaXml.selectSingleNode("saw:columns/saw:column[@formula='" + sFormula + "']/saw:displayFormat/saw:dataFormat");
      
   return null;      
}
